% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagememory.R
\name{storage.get.default}
\alias{storage.get.default}
\title{Get a value from a memory store.}
\usage{
\method{storage.get}{default}(storage, key)
}
\arguments{
\item{storage}{initialized storage}

\item{key}{key to retrieve value for}
}
\value{
Stored value for the key, \code{NULL} otherwise.
}
\description{
Gets a value, for a given key, from the store.
 
If there is no coresponding value for the key, then \code{NULL} is returned.
}
\examples{
library(magrittr)

# initialize default memory storage
my.storage <- storage.init()

# set a value into storage
storage.set(my.storage, "name", "Roy Wetherall")

# .. and some more
my.storage \%>\% 
  storage.set("age", 45) \%>\% 
  storage.set("alive", TRUE) \%>\%
  storage.set("children", c("Peter", "Grace", "Lucy"))

# check a key has been set
if (storage.has(my.storage, "name")) print("I know your name!")

# .. and that a key hasn't been set
if (!storage.has(my.storage, "address")) print("I don't know where you live!")

# get some values from storage
sprintf(
  "\%s is \%i years old.", 
  storage.get(my.storage, "name"),
  storage.get(my.storage, "age"))

# remove a value from storage
storage.unset(my.storage, "children")

# .. and show it's not there anymore
if (!storage.has(my.storage, "address")) print("I don't know who your children are!")

# clear all values from storage
storage.clear(my.storage)

# .. and everything is gone
if (!storage.has(my.storage, "name") && !storage.has(my.storage, "age")) print("I know nothing!")
}
