% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseBotResponse.R
\name{extractCode}
\alias{extractCode}
\title{extract the code and text from the text returned by LLM agent}
\usage{
extractCode(text, delimiter = "```")
}
\arguments{
\item{text}{A character string containing the text with embedded code blocks.}

\item{delimiter}{A character string representing the delimiter used to enclose the code blocks (default: "```").}
}
\value{
A list with two elements: 'code' and 'text'. 'code' contains the concatenated code blocks, and
        'text' contains the remaining text with code blocks removed.
}
\description{
This function parses the agents answer and returns the text and code as single blocks.
The results can be used for code execution and might be useful for displaying purposes later on.
}
\examples{
text <- "\n\nThe following, normalize the table and do PCA.
\n\n```\ndata <- read.table(\"test.txt\", header = TRUE, sep = \"\\\\t\")\n```"
result <- extractCode(text)
print(result$code)
print(result$text)


}
