% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_experimental_data.R
\name{process_raw_experiments}
\alias{process_raw_experiments}
\title{Process raw experimental data}
\usage{
process_raw_experiments(data = NULL, n_pmcs = NULL)
}
\arguments{
\item{data}{Validation data.}

\item{n_pmcs}{Number of PMCS used on the experiment}
}
\value{
Returns a list of dataframes as stated in the description.
}
\description{
\code{process_raw_experiments} splits the data into separate dataframes.
The number of different dataframes is the number of subexperiments and the number of variables on each one is the number of PMCs.
The validation data is on the form of several subexperiments that don't need to be merged together.
The intent of the data is to provide information on how each HEM behaves when put against another HEM.
The validation data them is a collection of subexperiments where each HEM is put against each other.
}
\examples{
n_pmcs <- 6
data_much <- mergingTools::process_raw_experiments(data = data_much_raw_vignette,
                                                   n_pmcs = n_pmcs)
}
\keyword{HRM}
\keyword{MUCH}
