% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emit_message.R
\name{emit_message}
\alias{emit_message}
\title{Provide a message with a consistent format}
\usage{
emit_message(..., .format = NULL, .f_name = TRUE, .issue = TRUE)
}
\arguments{
\item{...}{a collection of string expressions
and named arguments for string interpolation.
Bare strings will be pasted together and
separated by newlines. Named arguments are
used to provide values for string interpolation
in the message.}

\item{.format}{a format template for a
message. If not provided, the default template
of \code{"{.f_name}: {text}"} will be used.}

\item{.f_name}{the name of the function that
relates to the message. If not provided, the
function name will be obtained from the
function call stack.}

\item{.issue}{a logical value that indicates
whether the message should be issued at all.
This is to control for the verbosity of
messages under certain circumstances.}
}
\description{
Create a message using a message body that
can be formed from multiple text objects.
If a single text object is provided then the
message will appear on a single line. If
multiple text fragments are provided then
they will be separated by newlines (in the
order provided). Custom formatting is
possible by providing a messaging template
that uses the string expression scheme used
in the \code{glue} package.
}
\examples{
# Write a function that yields a message with
# the requested number of info lines
yield_a_message <- function(msgs) {

  if (msgs > 3) msgs <- 3

  # Create some strings can serve as additional
  # info for the message
  message_components <-
    c("* message info 1",
      "* message info 2",
      "* message info 3")

  # Generate and emit a formatted message
  emit_message(
    "There (is/are) {number} thing(s) to note",
    message_components[1:msgs],
    number = msgs,
    .format = "{.f_name} info: {text}")
}

# When that function is called, a formatted
# message will appear; here are some examples:
yield_a_message(msgs = 3)

yield_a_message(msgs = 2)

yield_a_message(msgs = 1)
}
