% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD.R
\name{SD_within_from_SD_r}
\alias{SD_within_from_SD_r}
\title{Within-Group Standard Deviation for Matched Groups}
\usage{
SD_within_from_SD_r(SD_diff, r)
}
\arguments{
\item{SD_diff}{standard deviation of the difference}

\item{r}{correlation between pair of observations}
}
\value{
Within standard deviation
}
\description{
Computes the within-group standard deviation for matched groups. This within-group standard deviation can be used to calculate standardized mean differences for matched groups. This method requires a correlation coefficient r.
}
\examples{
# SD_diff is the standard deviation of the group difference
SD_diff <- 2
# r is the correlation coefficient between the groups
r <- 0.5
SD_within_from_SD_r(SD_diff, r)
}
\references{
Borenstein, M., Hedges, L.V., Higgins, J.P.T. and Rothstein, H.R. (2009). Effect Sizes Based on Means . In Introduction to Meta-Analysis (eds M. Borenstein, L.V. Hedges, J.P.T. Higgins and H.R. Rothstein). https://doi.org/10.1002/9780470743386.ch4
}
