% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD.R
\name{SDp_from_SEp}
\alias{SDp_from_SEp}
\title{Standard Deviation from the Pooled Standard Error}
\usage{
SDp_from_SEp(SEp, n1, n2)
}
\arguments{
\item{SEp}{pooled standard error}

\item{n1}{sample size group 1}

\item{n2}{sample size group 2}
}
\value{
Pooled standard deviation
}
\description{
\strong{IMPORTANT}: For a single group, use \code{\link[=SD_from_SE]{SD_from_SE()}}!
Calculates the standard deviation from the pooled standard error and sample sizes of two groups (e.g., for intervention effects). This method is the reverse of \code{\link[=SEp_from_SDp]{SEp_from_SDp()}}.
}
\examples{
#pooled standard error, sample size 1 and sample size 2
SE <- 0.12
n1 <- 140
n2 <- 140

SDp_from_SEp(SE, n1, n2)
}
\references{
\href{https://handbook-5-1.cochrane.org/chapter_7/7_7_3_3_obtaining_standard_deviations_from_standard_errors.htm}{Cochrane Handbook}
}
\seealso{
\code{\link[=SD_from_SE]{SD_from_SE()}} for a single group.
\code{\link[=SEp_from_SDp]{SEp_from_SDp()}} if the standard error should be computed instead.
}
