% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal.R
\name{dispersal}
\alias{dispersal}
\title{Dispersal process}
\usage{
dispersal(dispersal_kernel, abundance, weights)
}
\arguments{
\item{dispersal_kernel}{\verb{<numeric matrix>} dispersal kernel.}

\item{abundance}{\verb{<numeric matrix>} abundance matrix.}

\item{weights}{\verb{<numeric matrix>}  optional weights in form of a matrix
that has the same dimensions as the abundance and a range: between \verb{0, 1}.
Should not contain any \code{NA}.}
}
\value{
\verb{<numeric matrix>} Dispersed abundance matrix.
}
\description{
Disperse a (abundance) matrix using a dispersal kernel and optional weights.
}
\details{
The abundance matrix is dispersed using the dispersal kernel.
If a matrix of weights is supplied, the individuals will redistribute
within the dispersal kernel according to the weights.
I.e. individuals will more likely move towards areas with a higher
weight, if they are within their dispersal distance.
Note:
\itemize{
\item the abundance is modified in place, to optimize performance.
\item Any \code{NA} or \code{NaN} in abundance or weights will be (in-place) replaced by \code{0}.
}
}
\examples{
n <- 10
n2 <- n^2
abu <- matrix(1:n2, nrow = n, ncol = n)
suitab <- matrix(1, nrow = n, ncol = n)
kernel <- calculate_dispersal_kernel(
    max_dispersal_dist = 4,
    kfun = negative_exponential_function,
    mean_dispersal_dist = 1.2
)
res1 <- dispersal(
    dispersal_kernel = kernel,
    abundance = abu
)
res2 <- dispersal(
    dispersal_kernel = kernel,
    abundance = abu,
    weights = suitab
)
stopifnot(sum(res1) - sum(res2) < 0.01)
# Note that the abundance is modified in place, i.e:
stopifnot(sum(abu - res2) < 0.01)
}
