% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{metabolic_meta}
\alias{metabolic_meta}
\title{Dataset for reproducing the meta-analysis}
\format{
A data frame with 391 rows and 21 variables:
\describe{
\item{study}{last name of first author and year of publication}
\item{endpoint}{the clinical endpoint analyzed, it may be either: VO2max (maximal oxygen uptake), Flow-mediated Dilation, BMI (body mass index), Body Mass, Body Fat, Systolic Blood Pressure, Diastolic Blood Pressure, HDL, LDL, Triglycerides, Total Cholesterol, C-reactive Protein, Fasting Insulin, Fasting Glucose, HbA1c (glycated hemoglobin), or HOMA-IR (insulin resistance)}
\item{population}{population category from the study, it may be either: Healthy, Overweight/obese, Cardiac Rehabilitation, Metabolic Syndrome, or T2D}
\item{age}{the median age between the groups in the study, in years}
\item{category_age}{age category based on the age column, it may be either: < 30 y, 30 - 50 y, or > 50 y}
\item{duration}{the training duration, in weeks}
\item{category_duration}{training duration category based on the duration column, it may be either: < 5 weeks, 5 - 10 weeks, or > 10 weeks}
\item{men_ratio}{the men ratio (total men divided by sample size) reported in the study}
\item{category_men_ratio}{men ratio category based on the men_ratio column, it may be either: < 0.5 or > 0.5}
\item{type_exercise}{the type of exercise used for exercise training, it may be either running or cycling}
\item{bsln}{the baseline value reported for the clinical endpoint (the median between groups is used)}
\item{bsln_adjusted}{the adjusted baseline value for the clinical endpoint. Values were adjusted according to their categories described in the paper. For example, VO2max values were adjusted to their age and sex percentile ranks, etc. From these values, the categories are defined in 'category_bsln'}
\item{category_bsln}{the baseline category based on the bsln column}
\item{N_HIIE}{sample size of the HIIE (High-intensity Interval Exercise) group}
\item{Mean_HIIE}{mean difference between pre- and post-training in the HIIE (High-intensity Interval Exercise) group}
\item{SD_HIIE}{standard deviation of the difference between pre- and post-training in the HIIE (High-intensity Interval Exercise) group}
\item{N_MICT}{sample size of the MICT (Moderate-intensity Continuous Training) group}
\item{Mean_MICT}{mean difference between pre- and post-training in the MICT (Moderate-intensity Continuous Training) group}
\item{SD_MICT}{standard deviation of the difference between pre- and post-training in the MICT (Moderate-intensity Continuous Training) group}
\item{HIIE}{the type of HIIE used in the study: it may be either: HIIT (High-intensity Interval Training) or SIT (Sprint Interval Training)}
\item{desired_effect}{the desired effect expected for post-training improvements. This is needed simply to display the effects related to HIIE and MICT on the same side of the forest plot throughout the clinical endpoints}
}
}
\source{
\url{https://journals.lww.com/acsm-msse/Fulltext/2021/03000/Effectiveness_of_HIIE_versus_MICT_in_Improving.12.aspx}
}
\usage{
metabolic_meta
}
\description{
A dataset containing the processed data from the studies necessary to reproduce the meta-analysis.
}
\keyword{datasets}
