% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{read.hills}
\alias{read.hills}
\title{Read HILLS from Plumed}
\usage{
read.hills(file = "HILLS", per = c(FALSE, FALSE), pcv1 = c(-pi, pi),
  pcv2 = c(-pi, pi), ignoretime = FALSE)
}
\arguments{
\item{file}{HILLS file from Plumed.}

\item{per}{logical vector specifying periodicity of collective variables.}

\item{pcv1}{periodicity of CV1.}

\item{pcv2}{periodicity of CV2.}

\item{ignoretime}{time in the first column of the HILLS file will be ignored.}
}
\value{
hillsfile object.
}
\description{
`read.hills` reads a HILLS file generated by Plumed and returns a hillsfile object.
User can specify whether some collective variables are periodic.
}
\examples{
l1<-"1 -1.409  2.808 0.3 0.3 1.111 10"
l2<-"2 -2.505  2.791 0.3 0.3 1.111 10"
l3<-"3 -2.346  2.754 0.3 0.3 1.069 10"
l4<-"4 -1.198  2.872 0.3 0.3 1.074 10"
fourhills<-c(l1,l2,l3,l4)
tf <- tempfile()
writeLines(fourhills, tf)
read.hills(tf, per=c(TRUE,TRUE))
}
