% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABC.Algorithm.R
\name{ABC}
\alias{ABC}
\title{Optimization using Artificial Bee Colony Algorithm}
\usage{
ABC(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar, cycleLimit = as.integer(numVar *
  numPopulation))
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{cycleLimit}{a positive integer to determine number of times allowed for
candidate solution to not move.  The default value is \code{as.integer(numVar * numPopulation)}.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Artificial Bee Colony
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Karaboga & Akay, 2009).
It inspired by type of bee. They are three types of bee employeed,
onlooker and scout. Employed bee work by finding food source.
Onlooker bee work by finding better food source other than foods
that Employed bee found. Scout bee work by removing abandoned food
source. Each candidate solution in ABC algorithm represent as bee
and they will move in 3 phases employed, onlooker and scout.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item Employed bee phase (Perform local search and greedy algorithm for each candidate solution).
\item Onlooker bee phase (Perform local search and greedy algorithm for some candidate solutions).
\item Scout bee phase (Remove abandoned candidate solutions).
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to employed bee phase.
}
}
\examples{
##################################
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(x){
    return(sum(x^2))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using artificial bee colony algorithm
resultABC <- ABC(sphere, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultABC)

}
\references{
Karaboga, D., & Akay, B. (2009). A comparative study of artificial bee colony algorithm.
Applied mathematics and computation, 214(1), 108-132.
}
\seealso{
\code{\link{metaOpt}}
}
