% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BHO.Algorithm.R
\name{BHO}
\alias{BHO}
\title{Optimization using Black Hole Optimization Algorithm}
\usage{
BHO(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Black-Hole based Optimization
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Hatamlou, 2013).
The main inspiration for BHO algorithm originates from black hole
that swallow all nearest star. Black hole represent candidate solution
with best fitness and other candidate solutions as star, so all star
search new best candidate solution while moving towards black-hole.
if star reaches better fitness than black hole, exchange its position.
star that too close to black hole (pass event horizon) wiil be replace
by new random candidate solution.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item select best candidate solution as black hole other as stars.
\item change each star location to moving toward black hole.
\item If a star reaches a location with lower cost than the black hole, exchange their locations.
\item If a star crosses the event horizon of the black hole, replace it
     with a new star in a random location in the search space.
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop.
}
}
\examples{
##################################
## Optimizing the step function

# define step function as objective function
step <- function(x){
    result <- sum(abs((x+0.5))^2)
    return(result)
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-100,100), nrow=2)

## calculate the optimum solution using black hole optimization
resultBHO <- BHO(step, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using step function
optimum.value <- step(resultBHO)

}
\references{
Hatamlou, A. (2013). Black hole: A new heuristic optimization approach for data clustering.
Information Sciences, 222(December), 175–184. https://doi.org/10.1016/j.ins.2012.08.023
}
\seealso{
\code{\link{metaOpt}}
}
