% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOA.Algorithm.R
\name{GOA}
\alias{GOA}
\title{Optimization using Grasshopper Optimisation Algorithm}
\usage{
GOA(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Grasshopper
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
Grasshopper Optimisation Algorithm (GOA) was proposed by (Mirjalili et al., 2017).
The algorithm mathematically models and mimics the
behaviour of grasshopper swarms in nature for solving optimisation
problems.
}
\examples{
##################################
## Optimizing the schewefel's problem 1.2 function

# define schewefel's problem 1.2 function as objective function
schewefels1.2 <- function(x){
  dim <- length(x)
  result <- 0
    for(i in 1:dim){
       result <- result + sum(x[1:i])^2
   }
  return(result)
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using grasshoper algorithm
resultGOA <- GOA(schewefels1.2, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using schewefel's problem 1.2 function
optimum.value <- schewefels1.2(resultGOA)

}
\references{
Shahrzad Saremi, Seyedali Mirjalili, Andrew Lewis, Grasshopper Optimisation
Algorithm: Theory and application, Advances in Engineering Software,
Volume 105, March 2017, Pages 30-47, ISSN 0965-9978,
https://doi.org/10.1016/j.advengsoft.2017.01.004
}
\seealso{
\code{\link{metaOpt}}
}
