% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.inc.R
\name{subset.inc}
\alias{subset.inc}
\title{Decision Inconsistency index and Across-Studies Inconsistency index in
subsets of studies}
\usage{
\method{subset}{inc}(x, data, subset, ...)
}
\arguments{
\item{x}{An object created with \code{\link{inc}}.}

\item{data}{A data frame with the same number of primary studies as those
included in the meta-analysis and containing the variables based on which
subset analysis is to be performed.}

\item{subset}{A logical vector to select studies for subset analysis.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of class \code{\link{inc}}.
}
\description{
Computation of the Decision Inconsistency index and the Across-Studies
Inconsistency index for specific subsets of studies (allowing for
subgroup analysis).
}
\details{
Computes the Decision Inconsistency index and the Across-Studies 
Inconsistency index for a subset (subgroup) of studies.
}
\examples{
data(anticoagulation)
inc_anticoagulation <-
  inc(anticoagulation, dt1 = 16, dt2 = 31, dt3 = 60,
    br = 0.5, sm = "OR", transf = FALSE)
inc_anticoagulation

# Example with subset analysis restricted to studies with a low risk of bias:
data(anticoagulation_df)
subset1_anticoagulation <-
  subset(inc_anticoagulation, anticoagulation_df, RoB == "Low")
subset1_anticoagulation
 
# Example with subset analysis excluding studies with a high risk of bias
# (resulting in the same subset of studies as no study has "Moderate" RoB):
subset2_anticoagulation <-
  subset(inc_anticoagulation, anticoagulation_df, RoB != "High")
subset2_anticoagulation

}
\author{
Bernardo Sousa-Pinto \email{bernardo@med.up.pt},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
