% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microbiomeage.R
\name{microbiomeage}
\alias{microbiomeage}
\title{Predict microbiome age.}
\usage{
microbiomeage(l6.relabundtab, bal6)
}
\arguments{
\item{l6.relabundtab}{list of taxa summary table from phylum up to genus level merged to mapping file outputed from QIIME of all included studies.}

\item{bal6}{reference data for model training (taxa summary table from phylum up to genus level merged to mapping file outputed from QIIME of the Bangladesh study).}
}
\value{
list of training and test sets of Bangladesh data, shared genera list, relative abundance data of shared genera, randomforest fit, RF model performance plot,predicted microbiome age of Bangladesh data and data of other included studies.
}
\description{
This function predicts microbiome age using Random Forest model based on relative abundances of bacterial genera shared with the Bangladesh study (Subramanian et al 2014).
This function gets the shared genera list between the Bangladesh study and all other included studies,
get the training and test sets from Bangladesh data based on the shared genera list,
fit the train Random Forest model and predict microbiome age in the test set of Bangladesh data and data from all included studies,
check for performance of the model based on the shared genera list on Bangladesh healthy cohort data, reproduce the findings of the Bangladesh malnutrition study.
}
\examples{
\donttest{
# The data used for this example are available
# in the "metamicrobiomeR" package version in Github.
# Download example data from the package github repo
#setwd("your directory") #put your working directory inside the quotation marks
download.file(url = "https://github.com/nhanhocu/metamicrobiomeR/archive/master.zip",
destfile = "metamicrobiomeR-master.zip")
# unzip the .zip file
unzip(zipfile = "metamicrobiomeR-master.zip")
#Load data from each study and put in a list
#Load Bangladesh train data
patht<-paste(getwd(),
"metamicrobiomeR-master/inst/extdata/QIIME_outputs/Bangladesh/tax_mapping7", sep="/")
bal6 <- utils::read.delim(paste(patht, "Subramanian_et_al_mapping_file_L6.txt", sep="/"))
colnames(bal6)<-tolower(colnames(bal6))
# Load data of 3 other studies
#format for data of other studies should be similar to Bangladesh data,
# must have 'age.sample' variable as age of infant at stool sample collection
data(gtab.3stud)
names(gtab.3stud)
#predict microbiome age on Bangladesh data and
# data of other three studies based on shared genera across 4 studies
#Predict microbiome age on train and test data (take time to run)
miage<-microbiomeage(l6.relabundtab=gtab.3stud, bal6=bal6)
#list of shared genera that are available in the Bangladesh study
# and other included studies
miage$sharedgenera.importance
#check performance
gridExtra::grid.arrange(miage$performanceplot$ptrain, miage$performanceplot$ptest,nrow=1)
#replicate the findings of Subramanian et al paper
ggplot2::ggplot() +geom_point(data=miage$microbiomeage.bangladesh$all,
aes(x=age.sample, y=age.predicted, colour=health_analysis_groups))
}
}
\keyword{Forest.}
\keyword{Random}
\keyword{age}
\keyword{microbiome}
