% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{calc_neutral_loss}
\alias{calc_neutral_loss}
\title{Calculate neutral losses from precursor ion mass and fragment ion masses}
\usage{
calc_neutral_loss(data, m_z_col)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{m_z_col}{Which column holds the precursor m/z? Uses \code{\link[rlang]{args_data_masking}}.}
}
\value{
A tibble with added neutral loss spectra. A new list column is created named \code{Neutral_Loss}.
}
\description{
Calculate neutral loss spectra for all ions with available MSn spectra in \code{data}. To calculate neutral losses, MSn spectra are required.
See \code{\link[metamorphr]{read_mgf}}. This step is required for subsequent filtering based on
neutral losses (\code{\link[metamorphr]{filter_neutral_loss}}). Resulting neutral loss spectra are stored in tibbles in a new list column named \code{Neutral_Loss}.
}
\examples{
toy_mgf \%>\%
  calc_neutral_loss(m_z_col = PEPMASS)
}
