% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmetanet.R
\name{ggmetanet}
\alias{ggmetanet}
\title{ggmetanet}
\usage{
ggmetanet(
  metanetwork,
  g = NULL,
  beta = 0.1,
  legend = NULL,
  mode = "TL-tsne",
  edge_thrs = NULL,
  layout_metaweb = FALSE,
  nrep_ly = 1,
  flip_coords = FALSE,
  diff_plot_bool = FALSE,
  alpha_per_group = NULL,
  alpha_per_node = NULL,
  alpha_interactive = FALSE,
  ggnet.config = ggnet.default,
  TL_tsne.config = TL_tsne.default
)
}
\arguments{
\item{metanetwork}{object of class metanetwork}

\item{g}{network (igraph object) to represent, default is metaweb}

\item{beta}{the diffusion parameter of the diffusion kernel, a positive scalar controlling the
vertical squeezing of the network}

\item{legend}{resolution for the legend, legend resolution must be a coarser resolution than the resolution of g, default is NULL}

\item{mode}{mode used for layout, 'TL-tsne' or 'group-TL-tsne' Default is 'TL-tsne'.
This argument can also be a two-column matrix for custom layout.}

\item{edge_thrs}{if non-null, a numeric (between 0 and 1) indicating an edge threshold for the representation}

\item{layout_metaweb}{a boolean indicating whether the layout of the metaweb should be used to represent the network
to use metaweb layout = TRUE, you need first to compute metaweb layout for this beta value using \code{attach_layout()}}

\item{nrep_ly}{If several layouts for this beta value are attached to the metaweb (if \code{layout_metaweb = T}), index of the layout to use, see \code{attach_layout()}}

\item{flip_coords}{a boolean indicating whether coordinates should be flipped.}

\item{diff_plot_bool}{boolean, do not edit by hand}

\item{alpha_per_group}{controlling alpha per group (only for 'ggnet' vis), a list of format
\code{list(resolutions = "XX",groups = XX,alpha_focal = XX,alpha_hidden = XX)}, see example}

\item{alpha_per_node}{controlling alpha per node (only for 'ggnet' vis), a list of format
\code{list(nodes = XX,alpha_focal = XX,alpha_hidden = XX)}, see example
In that case, y-axis is the trophic level and x-axis is the layout axis}

\item{alpha_interactive}{a boolean indicating whether alpha (that is node transparency)
should be asked in interactive mode to the user}

\item{ggnet.config}{configuration list for ggnet representation, default is ggnet.default}

\item{TL_tsne.config}{configuration list for mode 'TL-tsne', default is TL_tsne.default}
}
\value{
an object of class \code{ggplot}, the current network representation
}
\description{
Function that provides network static representation  (using 'ggnet') from a
'metanetwork' object using 'TL-tsne' or 'group-TL-tsne' layout.
}
\details{
At each call of the function with 'TL-tsne' layout, it computes a layout for the current beta value.
If a layout is already attached to the current network, it uses directly this layout (without computing).
This function provides many static visualisation tools:
\itemize{
\item customising ggnet parameters wrapped in \code{ggnet.config}
\item legending using the trophicTable
\item playing on group transparency (alpha)
\item using the metaweb layout
\item building a legend for large networks.
}
}
\examples{
library(metanetwork)
library(igraph)

#lattice example
g = make_lattice(dim = 2,length = 4,directed = TRUE)
#building metanetwork and computing trophic levels
meta0 = build_metanet(g) 
meta0 = compute_TL(meta0)
ggmetanet(meta0)
#storing layout
meta0 = attach_layout(meta0)
ggmetanet(meta0)

#custom ggnet parameters
ggnet.custom = ggnet.default
ggnet.custom$label = TRUE
ggnet.custom$edge.alpha = 0.5
ggnet.custom$alpha = 0.7
ggnet.custom$arrow.size = 1
ggnet.custom$max_size = 12

# using pre-computed layout and custom ggnet parametersfor vertebrates metaweb
data("meta_vrtb")
#custom ggnet parameters
ggnet.custom = ggnet.default
ggnet.custom$label = TRUE
ggnet.custom$edge.alpha = 0.5
ggnet.custom$alpha = 0.7
ggnet.custom$arrow.size = 1
ggnet.custom$max_size = 12
#at SBM group level
beta = 0.005
ggmetanet(meta_vrtb,g = meta_vrtb$metaweb_group,flip_coords = TRUE,
         beta = beta,legend = "group",
         ggnet.config = ggnet.custom,edge_thrs = 0.1)

}
\seealso{
\code{\link[=attach_layout]{attach_layout()}},\link{ggnet.default}
}
