% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_export_ipath3.R
\name{export_ipath3}
\alias{export_ipath3}
\title{export_ipath3}
\usage{
export_ipath3(
  spectral_count_object,
  type_export,
  target_variable,
  sample_condition,
  hexadecimal_color,
  taxonomic_levels = NULL,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing protein abundance expressed as spectral counts by a 
taxonomic level. The functional annotation must be added to this
object. The format of this object is similar to that generated from 
the function "add_kegg".}

\item{type_export}{Character indicating the type of export to be used. The
possible options are: i) "all" that selects all the KO terms from a given 
sample or a given condition; and, ii) "selection" that extracts the 
KO terms present in selected taxonomic entities (one or more).}

\item{target_variable}{Character indicating the column name from metadata 
containing the condition or sample to be analyzed.}

\item{sample_condition}{Atomic vector indicating the sample from which 
the functional information will be extracted.}

\item{hexadecimal_color}{Character indicating the color to be used in 
iPATH3, this value must be indicated in hexadecimal format (eg. #ff0000).}

\item{taxonomic_levels}{Optional vector indicating the taxonomic levels
from which the KO terms will be extracted. This option is needed only
if the type of export is "selection".}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create a file in the workstation of the user.}
}
\value{
A csv file containing the KO terms present in a given sample or 
   condition. The content of this file can be inserted directly in the tool  
   \href{https://pathways.embl.de/}{iPATH3}. The width of the lines in 
   iPATH3 will be displayed by the  percentage of spectra in the selected 
   sample or condition. In this way, KO terms belonging to a given taxonomic 
   level are represented in three intervals based on their abundace: i) 
   below 2 percent, i) between 2 to 10 percent, or i) above 10 percent.
}
\description{
Exports the KEGG Orthology (KO) terms in the adapted format to be used in 
the tool \href{https://pathways.embl.de/}{iPATH3}. The exported data is 
obtained from a "spectral_count_object" containing the functional 
annotation of the identified proteins from one condition or sample.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(species_annot_fw)

export_ipath3(
   species_annot_fw, 
   "all", 
   "SampleID", 
   "Q1_prot", 
   "#840AA3"
)

taxonomic_entities <- c("Bacteroides caccae", "Coprococcus catus", "Merdimonas faecis")
export_ipath3(
   species_annot_fw, 
   "selection", 
   "SC_name", 
   "FW2", 
   "#28c1df", 
   taxonomic_entities
)

\dontshow{setwd(.old_wd)}
}
