% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_select_element.R
\name{select_element}
\alias{select_element}
\title{select_element}
\usage{
select_element(spectral_count_object, target_variable, list_elements)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts 
from peptides, subgroups, groups or taxonomic levels. The format 
of this object is similar to that generated from the 
functions "getsc_specific" and "crumble_taxonomy."}

\item{target_variable}{Character indicating the variable that contains 
the elements to be kept. The options are : i) "peptides", ii) "proteins", 
iii) "soubgroups", iv) "groups", v) "sequences", vi) "species", vii) "genus",
viii) "family", ix) "order", x) "class", xi) "phylum" or xii) "superkingdom". 
To select xiii) "samples", it should be indicated the name of ONE column from 
metadata.}

\item{list_elements}{Atomic vector indicating the elements to be kept 
For "samples", indicate the element(s) present in the provided variable 
from metadata. For "peptides", "proteins", "subgroups" and "groups" 
provide the X!Tandem nomenclature. For "sequences", provide the 
peptide sequences expressed as aminoacids. For any taxonomic level, provide
the taxonomic entities.}
}
\value{
A list defined as "spectral_count_object" with the elements 
   provided in the second argument of the function.
}
\description{
Keeps specific elements from a "spectral_count_object". These elements can 
be: i) samples, ii) peptides, iii) proteins, iv) soubgroups, v) groups, 
vi) sequences, vii) species, viii) genus, ix) family, x) order, 
xi) class, xii) phylum or xiii) superkingdom.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
data(species_fw)

data_selected_samples <- select_element(fecal_waters, "Methods", c("S_EF", "EF"))

data_selected_peptides <- select_element(fecal_waters, "peptides", c("pepa3c417", "pepd4664a1"))

data_selected_proteins <- select_element(species_fw, "proteins", c("a3.a9.a1", "a5.b81.a1"))

data_selected_subgroups <- select_element(species_fw, "subgroups", c("a3.a9", "b73.a5"))

data_selected_groups <- select_element(species_fw, "groups", c("a3", "b34", "c231"))

data_selected_sequences <- select_element(species_fw, "sequences", c("AQLNFGGTIENVVIRDEFPLEK"))

\dontshow{setwd(.old_wd)}
}
