% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logLik.meteDist.R
\name{logLikZ}
\alias{logLikZ}
\alias{logLikZ.meteDist}
\title{Compute log-likelihood z-score}
\usage{
logLikZ(x, ...)

\method{logLikZ}{meteDist}(x, nrep = 999, return.sim = FALSE, ...)
}
\arguments{
\item{x}{a \code{meteDist} object}

\item{...}{arguments to be passed to methods}

\item{nrep}{number of simulations from the fitted METE distribution}

\item{return.sim}{logical; return the simulated liklihood values}
}
\value{
list with elements
\describe{
   \item{z}{The z-score}
   \item{sim}{\code{nrep} Simulated values (scaled by mean and sd as is the z-score) if return.sim=TRUE, NULL otherwise}
}
}
\description{
\code{logLikZ.meteDist} computes a log-likelihood z-score by simulation from a
fitted METE distribution
}
\details{
\code{logLikZ.meteDist} simulates from a fitted METE distribution (e.g. a species
abundance distribution or individual power distribution) and calculates the
likelihood of these simulated data sets. The distribution of these values is compared
against the likelihood of the data to obtain a z-score, specifically
z = ((logLik_obs - mean(logLik_sim)) / sd(logLik_sim))^2.
This value is squared so that it will be approximately Chi-squared distributed and a
goodness of fit test naturally arrises as \code{1 - pchisq(z, df=1)}.
}
\examples{
data(arth)
## object holding ecosystem structure function
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
## calculate individual power distribution
ipd1 <- ipd(esf1)
## calculate z-score, keeping all simulated log likelihoods for plotting
llz <- logLikZ(ipd1, nrep=100, return.sim=TRUE)

plot(density(llz$sim),xlim=range(c(llz$sim,llz$obs)),
     xlab='scaled log(likelihood)^2',col='red')
abline(v=llz$z,lty=2)
legend('top',legend=c('data','simulated'),col=c('black','red'),
      lty=c(1,1),bty='n')
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
mseZ.meteDist
}

