% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_data_chk.R
\name{metevalue.biseq.chk}
\alias{metevalue.biseq.chk}
\title{Check the BiSeq data format}
\usage{
metevalue.biseq.chk(
  input_filename_a,
  input_filename_b,
  sep = "\\t",
  bheader = FALSE
)
}
\arguments{
\item{input_filename_a}{metilene input file path. This file is a sep (e.g. TAB) separated file with two key columns and several value columns:
For exampe:
\tabular{rrrrrrrr}{
chr    \tab  pos     \tab   g1    \tab ...  \tab  g1 \tab  g2 \tab ... \tab g2 \cr
chr1 \tab  1    \tab  0.1 \tab  ... \tab   0.1\tab  0.2\tab ... \tab 0.2\cr
}

     - chr and pos are keys;

     - g1~g2: methylation rate data in groups.}

\item{input_filename_b}{metilene input file path. This file should stored as a sep(e.g. TAB) separated file with two key columns and several value columns:
The columns are (in order):

    - chr:   Chromosome

    - start: The position of the start site of the corresponding region

    - end: The position of the end site of the corresponding region

    - range: The range of the corresponding region

    - strand: Strand

    - median.p:  The median of p-values in the corresponding region

    - median.meth.group1 : The median of methylation level for the corresponding segment of group 1

    - median.meth.group2 : The median of methylation level for the corresponding segment of group 2

    - median.meth.diff:  The median of the difference between the methylation level}

\item{sep}{separator, default is the TAB key.}

\item{bheader}{a logical value indicating whether the input_filename_b file contains the names of the variables as its first line. By default, bheader = FALSE.}
}
\value{
list(file_a, file_b, file_a_b) returns a list with three pr-handled data.frames corresponding to the input_filename_a, input_filename_b file and a A JOIN B file.
}
\description{
Check the BiSeq data format
}
\examples{
#data("demo_biseq_methyrate")
#data("demo_biseq_DMR")
#example_tempfiles = tempfile(c("demo_biseq_methyrate", "demo_biseq_DMR"))
#tempdir()
#write.table(demo_biseq_methyrate, file=example_tempfiles[1],row.names=FALSE,
#            col.names=TRUE, quote=FALSE, sep='\t')
#write.table(demo_biseq_DMR, file=example_tempfiles[2],
#             sep ="\t", row.names =FALSE, col.names =TRUE, quote =FALSE)
#### compute e-value and its adjustment ####
#result = metevalue.biseq.chk(example_tempfiles[1],
#                         example_tempfiles[2], bheader = TRUE)
}
