% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_MIC.R
\name{MIC}
\alias{MIC}
\title{Maximal Information Coefficient}
\usage{
MIC(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list (default).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Maximal Information Coefficient (MIC) for
a continuous predicted-observed dataset.
}
\details{
The \strong{MIC} function is a wrapper for the \code{mine_stat} function of the
\strong{minerva}-package, a collection of Maximal Information-Based Nonparametric statistics (MINE).
See Reshef et al. (2011).

For the predicted-observed case (PO), the \strong{MIC} is defined as follows:
\deqn{\textrm{MIC}(D)=\max_{PO<B(n)} M(D)_{X,Y} = \max_{PO<B(n)} \frac{I^ * (D,P,O)} {log(\min{P,O})},}{MIC(D)=max_{PO<B(n)} M(D)_{P,O}=max_{PO<B(n)} I * (D,P,O)/log(min(P,O)),} where
\eqn{B(n)=n^{\alpha}} is the search-grid size,
\eqn{I^*(D,P,O)}{I*(D,P,O)}
is the maximum mutual information over all grids \emph{P-by-O}, of the distribution
induced by D on a grid having \emph{P} and \emph{O} bins (where the probability
mass on a cell of the grid is the fraction of points of D falling in that cell).
Albanese et al. (2013).

For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
MIC(obs = X, pred = Y)
}
}
\references{
Reshef, D., Reshef, Y., Finucane, H., Grossman, S., McVean, G., Turnbaugh, P.,
Lander, R., Mitzenmacher, M., and Sabeti, P. (2011). Detecting novel associations
in large datasets.
\emph{Science 334, 6062}. \doi{10.1126/science.1205438}. \cr

Albanese, D., M. Filosi, R. Visintainer, S. Riccadonna, G. Jurman, C. Furlanello.
minerva and minepy: a C engine for the MINE suite and its R, Python and MATLAB wrappers.
\emph{Bioinformatics (2013) 29(3):407-408}. \doi{10.1093/bioinformatics/bts707}. \cr
}
\seealso{
\code{\link[rlang]{eval_tidy}}, \code{\link[rlang]{defusing-advanced}}
\code{\link[minerva]{mine_stat}}
}
