% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_metrics.R
\name{comp_metrics}
\alias{comp_metrics}
\title{Composition metrics}
\usage{
comp_metrics(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a data.frame with all the calculated composition measures:
\item{per_ephe}{\% Ephemeroptera.}
\item{per_molus}{\% Mollusca.}
\item{per_gastr}{\%Gastropoda.}
\item{per_biv}{\%Bivalvia.}
\item{per_crus}{\%Crustacea.}
\item{per_oli}{\% Oligochaeta.}
\item{per_amph}{\% Amphipoda.}
\item{per_ostr}{\% Ostracoda.}
\item{per_ephetricho}{\% Ephemeroptera + Trichoptera.}
\item{per_naid}{\% Naididae.}
\item{per_chir_dip}{\% Diptera Chironomidae.}
\item{per_non_chir_dip}{\%Diptera no Chironomidae.}
\item{per_polym}{\%Polymitarcidae.}
\item{per_hyal}{\%Hyalella.}
\item{per_coch}{\%Cochliopidae.}
\item{per_tricho}{\%Trichoptera.}
\item{per_subchiro}{\%Chironominae.}
\item{per_suborth}{\%Orthocladiinae.}
\item{per_subtany}{\%Tanypodinae.}
}
\description{
Calculates the relative abundance of particular taxa in the assemblage in percentage terms.
}
\details{
Provides information on the makeup of the assemblage and the relative contribution of the populations to the total fauna (Barbour et al., 1996).
}
\examples{

#Load example data
example_data

#Run comp_metrics with that example_data
compmetrics<-comp_metrics(example_data)

#Check results
compmetrics
}
\references{
Barbour MT, Gerritsen J, Griffith GE, Frydenborg R, McCarron E, White JS & Bastian ML (1996). A Framework for Biological Criteria for Florida Streams Using Benthic Macroinvertebrates. \doi{10.2307/1467948}
}
\seealso{
\link[metrix]{read_data}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
