% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imrp_ind.R
\name{imrp_ind}
\alias{imrp_ind}
\title{IMRP index}
\usage{
imrp_ind(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{Imrp_n}{The numerical IMRP index (Rodrigues Capítulo 1999).}
\item{Imrp_c}{The IMRP index water quality class (Rodrigues Capítulo 1999).}
}
\description{
Calculates the Indice de Macroinvertebrados en Rios Pampeanos Index
}
\details{
IMRP was created for the rivers of the Pampean plain (Rodrigues Capítulo 1999). This index is based on the sum of ecological values for each taxon. This value is inversely proportional to the degree of tolerance to contamination, varying from 0.1 for highly tolerant taxa to 2.0 for the most sensitive. Identification to family is sufficient to calculate the IMRP score.
}
\examples{

#Load example data
example_data

#Run imrp_ind with that example_data
imrp<-imrp_ind(example_data)

#Check results
imrp$Imrp_n
imrp$Imrp_c
}
\references{
Rodrigues Capítulo A (1999). The macroinvertebrate as indicators of water quality in Pampean rivers. \url{https://www.biotaxa.org/RSEA/article/view/32771}
}
\seealso{
\link[metrix]{read_data}, \link{biotic_ind}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
