% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xdep.R
\name{xdep.asym}
\alias{xdep.asym}
\title{Coefficient of extremal asymmetry}
\usage{
xdep.asym(
  xdat,
  qlev = NULL,
  nq = 40,
  qlim = c(0.8, 0.99),
  estimator = c("emp", "elik"),
  confint = c("none", "wald", "bootstrap"),
  level = 0.95,
  B = 999L,
  ties.method = "random",
  plot = TRUE,
  ...
)
}
\arguments{
\item{xdat}{an \code{n} by 2 matrix of observations}

\item{qlev}{vector of quantile levels at which to evaluate extremal asymmetry}

\item{nq}{integer; number of quantiles at which to evaluate the coefficient if \code{u} is \code{NULL}}

\item{qlim}{a vector of length 2 with the probability limits for the quantiles}

\item{estimator}{string indicating the estimation method, one of \code{emp} or empirical likelihood (\code{elik})}

\item{confint}{string for the method used to derive confidence intervals, either \code{none} (default) or a nonparametric \code{bootstrap}}

\item{level}{probability level for confidence intervals, default to 0.95 or bounds for the interval}

\item{B}{integer; number of bootstrap replicates (if applicable)}

\item{ties.method}{string; method for handling ties. See the documentation of \link[base]{rank} for available options.}

\item{plot}{logical; if \code{TRUE}, return a plot.}

\item{...}{additional arguments for backward compatibility}
}
\value{
an invisible data frame with columns
\describe{
\item{\code{qlev}}{quantile level of thresholds}
\item{\code{coef}}{extremal asymmetry coefficient estimates}
\item{\code{lower}}{either \code{NULL} or a vector containing the lower bound of the confidence interval}
\item{\code{upper}}{either \code{NULL} or a vector containing the lower bound of the confidence interval}
}
}
\description{
This function implements estimators of the bivariate
coefficient of extremal asymmetry proposed in Semadeni's (2021) PhD thesis.
 Two estimators are implemented: one based on empirical distributions, the second using empirical likelihood.
}
\details{
Let \code{U}, \code{V} be uniform random variables and define the partial extremal dependence coefficients
\deqn{\varphi_{+}(u) = \Pr(V > U \mid U > u, V > u),},
\deqn{\varphi_{-}(u) = \Pr(V < U \mid U > u, V > u),}
\deqn{\varphi_0(u) = \Pr(V = U \mid U > u, V > u).}
Define
\deqn{ \varphi(u) = \frac{\varphi_{+} - \varphi_{-}}{\varphi_{+} + \varphi_{-}}}
and the coefficient of extremal asymmetry as \eqn{\varphi = \lim_{u \to 1} \varphi(u)}.

The empirical likelihood estimator, derived for max-stable vectors with unit Frechet margins, is
\deqn{\widehat{\varphi}_{\mathrm{el}} = \frac{\sum_i p_i \mathrm{I}(w_i \leq 0.5) - 0.5}{0.5 - 2\sum_i p_i(0.5-w_i) \mathrm{I}(w_i \leq 0.5)}}
where \eqn{p_i} is the empirical likelihood weight for observation \eqn{i}, \eqn{\mathrm{I}} is an indicator function and \eqn{w_i} is the pseudo-angle associated to the first coordinate, derived based on exceedances above \eqn{u}.
}
\examples{
\dontrun{
samp <- rmev(n = 1000,
             d = 2,
             param = 0.2,
             model = "log")
xdep.asym(samp, confint = "wald")
xdep.asym(samp, method = "emplik", confint = "none")
}
}
\references{
Semadeni, C. (2020). Inference on the Angular Distribution of Extremes, PhD thesis, EPFL, no. 8168.
}
