% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfp2.R
\name{get_selected_variable_names}
\alias{get_selected_variable_names}
\title{Helper function to extract selected variables from fitted \code{mfp2} object}
\usage{
get_selected_variable_names(object)
}
\arguments{
\item{object}{fitted \code{mfp2} object.}
}
\value{
Character vector of names, ordered as defined by \code{xorder} in \code{\link[=mfp2]{mfp2()}}.
}
\description{
Simply extracts all variables for which not all powers are estimated to
be \code{NA}. The names refer to the original names in the dataset and do not
include transformations.
}
\examples{

# Gaussian model
data("prostate")
x = as.matrix(prostate[,2:8])
y = as.numeric(prostate$lpsa)
# default interface
fit = mfp2(x, y, verbose = FALSE)
get_selected_variable_names(fit)

}
