% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.vars.R
\name{best.vars}
\alias{best.vars}
\title{Best variables}
\usage{
best.vars(x)
}
\arguments{
\item{x}{A list of results of `maglm` and `mamglmg`}
}
\value{
A vector of terms of the best model.
}
\description{
Returns variables for the best model based on AIC
}
\examples{
#load species composition and environmental data
data(capcay)
adj.sr <- capcay$adj.sr
env_sp <- capcay$env_sp

#to fit a poisson regression model:
res <- maglm(data = env_sp, y = "adj.sr", family = "gaussian")

best.vars(res)
}
\seealso{
\code{\link{maglm}}, \code{\link{mamglm}}
}
