% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changefunctions.R
\name{qelbow}
\alias{qelbow}
\title{Finding corner of a quantile of ordered transformed p values}
\usage{
qelbow(porder, rbuff = 25, h = 30, qi = 0.9)
}
\arguments{
\item{porder}{matrix, usually feed from pboot functions. Bxm matrix of ordered p values, where B is the replication size and m is dimension.}

\item{rbuff}{right buffer, scaler, control for elbow()}

\item{h}{window size, default 30.}

\item{qi}{number between 0 and 1, quantile of the distribution. default 0.9.}
}
\value{
vector with two elements. estimates of the corner point by two methods.
}
\description{
Given a matrix of empirical distribution of ordered transformed p values, this function finds the corner point for a particular quantile.
}
\details{
In the distribution of the transformed ordered p values, we choose a particular quantile given by the user. We estimate the change point, which will be an estimate of the number of true alternatives corresponding to that quantile of the p values. As the values of the quantile increases, the estimates can only increasing, because we are dealing with ordered p values.
}
\examples{
    
\dontrun{    
n = 50;m = 250;m0 = 20;
sigeff = 1;
Sigma <- 0.25*diag(m)
X <- datgen(n,m,m0,sigeff,Sigma = Sigma)
porder <- pboot.1sample(X=X,B=100,ncpus = 1)
out <- qelbow(porder = porder)
out
}
}

