% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixCItest.R
\name{mixCItest}
\alias{mixCItest}
\title{Likelihood Ratio Test for (Conditional) Independence between Mixed Variables}
\usage{
mixCItest(x, y, S = NULL, suffStat, moreOutput = FALSE)
}
\arguments{
\item{x, y, S}{(Integer) position of variable X, Y and set of variables S,
respectively, in \code{suffStat}. It is tested whether X and Y are
conditionally independent given the subset S of the remaining variables.}

\item{suffStat}{A \code{data.frame}. Discrete variables must be coded as factors.}

\item{moreOutput}{If \code{TRUE}, the test statistic and the degrees of
freedom are returned in addition to the p-value (only for mixed variables).
Defaults to \code{FALSE}.}
}
\value{
A p-value. If \code{moreOutput=TRUE}, the test statistic and the
degrees of freedom are returned as well.
}
\description{
A likelihood ratio test for (conditional) independence between mixed
(continuous and unordered categorical) variables, to be used within
\code{pcalg::\link[pcalg]{skeleton}}, \code{pcalg::\link[pcalg]{pc}} or
\code{pcalg::\link[pcalg]{fci}}. It assumes that the variables in the test
follow a Conditional Gaussian distribution, i.e. conditional on each
combination of values of the discrete variables, the continuous variables
are multivariate Gaussian. Each multivariate Gaussian distribution is
allowed to have its own mean vector and covariance matrix.
}
\details{
The implementation follows Andrews et al. (2018). The same test is
also implemented in TETRAD and in the R-package rcausal, a wrapper for the
TETRAD Java library. Small differences in the p-values returned by
CGtest and the TETRAD/rcausal equivalent are due to differences in
handling sparse or empty cells.
}
\examples{
# load data (numeric and factor variables)
dat <- toenail2[,-1]

# analyse data
mixCItest(4, 1, NULL, suffStat = dat)
mixCItest(1, 2, 3, suffStat = dat)

## use mixCItest within pcalg::fci
fci.fit <- fci(suffStat = dat, indepTest = mixCItest, alpha = 0.01, p = 4)
if (requireNamespace("Rgraphviz", quietly = TRUE))
 plot(fci.fit)

}
\references{
Andrews B., Ramsey J., Cooper G.F. (2018): Scoring Bayesian
networks of mixed variables. \emph{International Journal of Data Science and
Analytics} 6:3-18.

Lauritzen S.L., Wermuth N. (1989): Graphical models for associations between
variables, some of which are qualitative and some quantitative.
\emph{The Annals of Statistics} 17(1):31-57.

Scheines R., Spirtes P., Glymour C., Meek C., Richardson T. (1998):
The TETRAD project: Constraint based aids to causal model specification.
\emph{Multivariate Behavioral Research} 33(1):65-117.
http://www.phil.cmu.edu/tetrad/index.html
}
\author{
Janine Witte
}
