% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_est.R
\name{cor_est}
\alias{cor_est}
\title{Calculates the correlation coefficient}
\usage{
cor_est(y, x, data, method = "pearson", se_method = "normal")
}
\arguments{
\item{y}{name of numeric vector variable.}

\item{x}{name of numeric vector variable.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}

\item{method}{a character string indicating which correlation coefficient
is used for the test. One of "pearson" (default), "kendall", or "spearman".}

\item{se_method}{Method to calculate standard error. See details.}
}
\value{
The correlation coefficient, standard error and complete data
degrees of freedom (dfcom).
}
\description{
\code{cor_est} Calculates the correlation coefficient and
standard error to be used in function \code{with.miceafter}.
}
\details{
The basic method to calculate the standard error is by:

\deqn{se = \sqrt(\frac{1}{n-3})}

For the Spearman correlation coefficients se_method "fieller"
is calculated as:

\deqn{se = \sqrt(\frac{1.06}{n-3})}

For the Kendall correlation coefficients se_method "fieller"
is calculated as:

\deqn{se = \sqrt(\frac{0.437}{n-4})}
}
\examples{
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=cor_est(y=BMI, x=Age))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_cor}}
}
\author{
Martijn Heymans, 2022
}
