% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_prop_nna.R
\name{pool_prop_nna}
\alias{pool_prop_nna}
\title{Calculates the pooled proportion and confidence intervals
using an approximate Beta distribution.}
\usage{
pool_prop_nna(object, conf.level = 0.95)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}

\item{conf.level}{Confidence level of the confidence intervals.}
}
\value{
The pooled proportion and the 95\% Confidence interval.
}
\description{
\code{pool_prop_nna} Calculates the pooled proportion and
confidence intervals using an approximate Beta distribution.
}
\details{
The parameters for the Beta distribution are calculated
using the method of moments (Gelman et al. p. 582).
}
\examples{

 imp_dat <- df2milist(lbpmilr, impvar='Impnr')
 ra <- with(imp_dat, expr=prop_nna(Radiation))
 res <- pool_prop_nna(ra)
 res

}
\references{
Raghunathan, T. (2016). Missing Data Analysis in Practice.
Boca Raton, FL: Chapman and Hall/CRC. (paragr 4.6.2)

Andrew Gelman, John B. Carlin, Hal S. Stern, David B.
Dunson, Aki Vehtari, Donald B. Rubin. (2003). Bayesian Data Analysis
(2nd ed). Chapman and Hall/CRC.
}
\seealso{
\code{\link{with.milist}}, \code{\link{prop_nna}}
}
\author{
Martijn Heymans, 2021
}
