% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_propdiff_ac.R
\name{pool_propdiff_ac}
\alias{pool_propdiff_ac}
\title{Calculates the pooled difference between proportions and standard error
according to Agresti-Caffo across multiply imputed datasets.}
\usage{
pool_propdiff_ac(object, conf.level = 0.95, dfcom = NULL)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}

\item{conf.level}{Confidence level of the confidence intervals.}

\item{dfcom}{Complete data degrees of freedom. Default
number is taken from function \code{propdiff_ac}}
}
\value{
The proportion, the Confidence intervals, the standard error and
statistic.
}
\description{
\code{pool_propdiff_ac} Calculates the pooled difference between proportions
and standard error according to Agresti-Caffo across multiply imputed datasets.
}
\details{
For the pooled difference between proportions the difference
between proportions according to Wald are used. The Agresti-Caffo
difference is used to derive the Agresti-Caffo confidence intervals.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=propdiff_ac(Chronic ~ Radiation))
res <- pool_propdiff_ac(ra)
res

}
\references{
Agresti, A. and Caffo, B. Simple and Effective Confidence
Intervals for Proportions and Differences of Proportions Result from
Adding Two Successes and Two Failures. The American Statistician.
2000;54:280-288.

Fagerland MW, Lydersen S, Laake P. Recommended confidence
intervals for two independent binomial proportions. Stat Methods Med Res.
2015 Apr;24(2):224-54.
}
\seealso{
\code{\link{with.milist}}, \code{\link{propdiff_ac}}
}
\author{
Martijn Heymans, 2021
}
