% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmr.R
\name{glmr}
\alias{glmr}
\title{Do the generalized linear model regression}
\usage{
glmr(
  physeq,
  group,
  factors = NULL,
  ref = NULL,
  family = binomial(link = "logit")
)
}
\arguments{
\item{physeq}{phyloseq object}

\item{group}{the group factor to regression}

\item{factors}{a vector to indicate adjuested factors}

\item{ref}{the reference group}

\item{family}{binomial() or gaussian()}
}
\description{
Do the generalized linear model regression
}
\examples{
\donttest{
data("Physeq")
phy<-normalize(physeq)
fit <-glmr(phy,group="SampleType")
}
}
\author{
Kai Guo
}
