% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cylinder-bundle-geometry.R
\name{simulate_bundle}
\alias{simulate_bundle}
\title{Generates a cross section of a cylinder bundle}
\usage{
simulate_bundle(
  density = 0.5,
  voxel_size = 10,
  rel_tol = 0.001,
  verbose = FALSE
)
}
\arguments{
\item{density}{A numeric value between 0 and 1 specifying the density of the
cylinders in the voxel. Defaults to \code{0.5}.}

\item{voxel_size}{A numeric value specifying the size of the voxel in micro-
meters. Defaults to \code{10}.}

\item{rel_tol}{A numeric value specifying the relative tolerance to reach the
target volume defined as \code{density * voxel_size^2}. Defaults to \code{1e-3}.}

\item{verbose}{A logical value specifying whether to print messages. Defaults
to \code{FALSE}.}
}
\value{
A list with the following components:
\itemize{
\item \code{sections}: A numeric matrix with 3 columns:
\itemize{
\item \code{x}: The x-coordinates of the centers of the cylinders;
\item \code{y}: The y-coordinates of the centers of the cylinders;
\item \code{r}: The radii of the cylinders in micrometers.
}
\item \code{voxel_size}: The size of the voxel in micrometers
}
}
\description{
Generates a cross section of a cylinder bundle with a given density and voxel
size. The cross section is generated by simulating a random distribution of
cylinders and computing the intersection of the cylinders with a plane. The
radii of the cylinders are drawn from a Gamma distribution fitted from data
retrieved by histology in the genu of the corpus callosum (Aboitiz et al.,
1992). The number of cylinders is determined by the density and the voxel
size.
}
\examples{
density <- 0.5
voxel_size <- 5 # micrometers
withr::with_seed(1234, {
  out <- simulate_bundle(density, voxel_size)
})

# Actual density in the simulated substrate
sum(out$sections[, "r"]^2 * pi) / voxel_size^2
}
\references{
Aboitiz, F., Scheibel, A. B., Fisher, R. S., & Zaidel, E. (1992).
Fiber composition of the human corpus callosum. Brain research, 598(1-2),
143-153.
}
