## Main Function


#' Compute relevant probabilities and estimates for selecting performance criteria
#'
#' @param n number of trials
#' @param tr true desired mastery level (default is 90%)
#' @param shape1 shape1 parameter for beta prior (default is 0.5)
#' @param shape2 shape2 parameter for beta prior (default is shape1 which means default is Jeffreys prior)
#' @param a significance level (defaul is 0.05)
#'
#'
#' @return A list of tables
#' @export
#'
#' @examples
#' miebl(n=5,tr=0.8,shape1=1,a=0.10)
#' # Creates results for 5 trials for 80% true mastery level w/ uniform prior and 0.10 significance.


miebl<-function(n,tr=0.90,shape1=0.5, shape2=shape1, a=0.05){
  out<-numeric(n+1)
  for(i in 0:n){
    out[i+1]<-1-pbeta(tr,shape1+i,shape2+n-i)
  }

  freqx<-1-pbinom(c(0:n),n,tr)+dbinom(c(0:n),n,tr)
  freqx3<-pbinom(c(0:n),n,tr)
  freqx4<-qbeta(a,c(0:n),n-c(0:n)+1)
  mc<-round(c(0:n)/n*100,2)
  shape1_x<-shape1+c(0:n)
  shape2_x<-shape2+n-c(0:n)

  out<-as.data.frame(cbind(c(0:n),mc,round(out,4),freqx,round(freqx4,4),shape1_x,shape2_x))
  inputs<-data.frame(tr,shape1,shape2,a)
  colnames(out)<-c("# Correct","performance Criterion","b","pv","lb","post_s1","post_s2")
  return(list(out,inputs))

}

