% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difMarkerPlots.R
\name{difMarkerPlots}
\alias{difMarkerPlots}
\title{Plot dot plots of features where both clusters are significantly different from the reference cluster without processing data before hand}
\usage{
difMarkerPlots(data, clusters, markers, diffclust, strat)
}
\arguments{
\item{data}{output from call to allmeds function}

\item{clusters}{clusterIDs of the desired clusters to compare and plot}

\item{markers}{indices of the columns of the data matrix for features to be analyse}

\item{diffclust}{clusterID of for cluster to statisticaly compare others to}

\item{strat}{clusterIDs for stratifying clusters as indicated by Citrus results}
}
\value{
Dot plots for all features where both clusters are significantly different from the reference cluster
}
\description{
Plot dot plots of features where both clusters are significantly different from the reference cluster without processing data before hand
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
graphs<-difMarkerPlots(data=meds,clusters=c(19999,19972,19988),
                       markers=c(2,3),diffclust=19999,strat=19999)
}
