% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterMarker.R
\name{filterMarker}
\alias{filterMarker}
\title{Filters list of data matrices with columns corresponding to the measured parameters of interest}
\usage{
filterMarker(clustdat, markers)
}
\arguments{
\item{clustdat}{a list of data matrices with list elements corresponding to clusters and matrices of intensities of measured parameters}

\item{markers}{Indices of the columns of parmeters to keep}
}
\value{
A list of data matrices with columns of data matrices only corresponding to measured parameters of interest
}
\description{
Filters list of data matrices with columns corresponding to the measured parameters of interest
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
meds2<-filterMarker(clustdat=meds,markers=c(2,3))
}
