% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdif.R
\name{plotdif}
\alias{plotdif}
\title{Plot dot plots of features where both clusters are significantly different from the reference cluster}
\usage{
plotdif(BJHdf, anovadata, strat)
}
\arguments{
\item{BJHdf}{results of a call to findsig}

\item{anovadata}{results of call to processforanova}

\item{strat}{clusterIDs for clusters that are stratifying}
}
\value{
Dot plots for all features where both clusters are significantly different from the reference cluster
}
\description{
Plot dot plots of features where both clusters are significantly different from the reference cluster
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
filteredmeds<-findclust(data=meds,clusters=c(19999,19972,19988))
meds2<-filterMarker(clustdat=filteredmeds,markers=c(2,3))
foranova<-processforanova(filtereddata=meds2)
ttests<-posthoc(processedDat=foranova,clustIDdif=19999)
sig<-findSig(posHocRes=ttests)
graphs<-plotdif(BJHdf=sig,anovadata=foranova,strat=19999)
}
