% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{sample,lnm-method}
\alias{sample,lnm-method}
\title{LNM Fitted Probabilities}
\usage{
\S4method{sample}{lnm}(x, size = 1, depth = 50000, newdata = NULL, ...)
}
\arguments{
\item{x}{An object of class lnm with fitted parameters \eqn{\hat{B}} and
which we want to use to form predictions on new samples.}

\item{size}{The number of samples to generate.}

\item{depth}{The depth to use when sampling the multinomial for each
simulated element.}

\item{newdata}{New samples on which to form predictions. Defaults to NULL, in
which case predictions are made at the same design points as those used
during the original training.}

\item{...}{Additional keyword arguments, for consistency with R's predict
generic (never used).}
}
\value{
A matrix of dimension \code{size} x \code{n_outcomes}, where each row
represents one sample from the posterior predictive of the fitted
logistic-normal multinomial model. Each row sums up to the depth argument,
which defaults to 5e4.
}
\description{
Given an input dataset, sample compositions that are consistent with the
input. Specifically, this samples from a multinomial with mean
\eqn{\phi^{-1}(Bx)}. The default depth is 5e4. Modify the "depth" parameter
to change this.
}
\examples{
example_data <- lnm_data(N = 50, K = 10)
xy <- dplyr::bind_cols(example_data[c("X", "y")])
fit <- lnm(
    starts_with("y") ~ starts_with("x"), xy, 
    iter = 25, output_samples = 25
)
head(sample(fit))
}
