% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-minimalRSD.R
\docType{package}
\name{minimalRSD}
\alias{minimalRSD}
\alias{minimalRSD-package}
\title{minimalRSD: A package for constructing CCD and BBD with minimum
level changes in the run sequence}
\description{
The minimalRSD package can be used to construct Central Composite
Designs (CCD) with full as well as fractional factorial points(half replicate)
and Box Behnken designs (BBD) with minimum number
of changes in the levels of input factors. These designs help in providing reducing
cost-effective Response Surface Designs (RSDs).
This package provides three categories of important functions:
min-bbd, min_ccd and min_ccd_2.
}
\details{
The package minimalRSD is an implementation of the concepts
and theory discussed by Varghese et al. (2017). For detailed information
and concepts users are advised to see the following reference.
}
\section{minimalRSD functions}{

min_bbd: Generate minimally changed BBD for a given number of input factors. \cr
min_ccd: Generate minimally changed CCD for a given number of input factors. \cr
min_ccd_2: Generate minimally changed CCD with fractinalfactorial points
(half replicate) for a given number of factors. \cr
}
\author{
Shwetank Lall \email{shwetanklall@gmail.com}
}
\references{
Eldho Varghese, Arpan Bhowmik,Seema Jaggi, Cini Varghese
and Shwetank Lall (2017). On the construction of response surface designs with
minimum level changes. Utilitas Mathematica, (under print).\cr
Eldho Varghese, Arpan Bhowmik,Seema Jaggi, Cini Varghese
and Charanjit Kaur (2017). On the generation of cost
effective response surface designs. Computers and
Electronics in Agriculture, 133,37-45.
}

