% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minicanada.R
\name{minicanada}
\alias{minicanada}
\title{Make a tile grid map of Canada}
\usage{
minicanada(pt, pt_colors, border_colors = rep("white", 13), pt_names = TRUE,
  pt_name_colors = rep("white", 13), pt_name_cex = 1, font = NULL)
}
\arguments{
\item{pt}{A vector of Canadian province and territory postal abbreviations.
This vector must be some permutation of \code{canada_abb}.}

\item{pt_colors}{A vector of "colors" in the R sense. For example strings
(\code{"blue"}), hex codes (\code{"#D0C7B9"}), etc. The ith color in this
vector will be the color of square that represents the ith element of
\code{pt}.}

\item{border_colors}{Like \code{pt_colors} but specifying the border
of the square.}

\item{pt_names}{Should the postal codes for each province or territory be
displayed in the center of the province or territory? The default value is
\code{TRUE}.}

\item{pt_name_colors}{Like \code{pt_colors} but specifying the color
of the text displayed in each province or territory.}

\item{pt_name_cex}{The size of the text displayed inside of each province or
territory.}

\item{font}{The font of the text displayed inside of each province or
territory. The values \code{"serif"}, \code{"sans"}, and \code{"mono"} are
safest to use. Use other fonts at your own risk. If \code{NULL} a
sans-style font will be used.}
}
\description{
Make a tile grid map of Canada
}
\examples{
\dontrun{
 minicanada(canada_abb, 1:13)
}
}

