% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnVR_wrappers.R
\name{lnVR_main}
\alias{lnVR_main}
\title{Main Effect: Log of the Variability Ratio}
\usage{
lnVR_main(
  data,
  col_names = c("yi", "vi"),
  append = TRUE,
  Ctrl_sd,
  Ctrl_n,
  A_sd,
  A_n,
  B_sd,
  B_n,
  AB_sd,
  AB_n
)
}
\arguments{
\item{data}{Data frame containing the variables used.}

\item{col_names}{Vector of two strings to name the output columns for the effect size and its sampling variance. Default is 'yi' and 'vi'.}

\item{append}{Logical. Append the results to \code{data}. Default is TRUE}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_sd}{Standard deviation from the A treatment}

\item{A_n}{Sample size from the A treatment}

\item{B_sd}{Standard deviation from the B treatment}

\item{B_n}{Sample size from the B treatment}

\item{AB_sd}{Standard deviation from the interaction AxB treatment}

\item{AB_n}{Sample size from the interaction AxB treatment}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the overral log of the variability ratio for Factor A
across levels of Factor B.
}
\details{
See the package vignette for a detailed description of the formula.
}
\examples{
# Example for main effect in 2x2 factorial focusing on variability (Fire x Grazing)
data <- data.frame(
  study_id = 1:2,
  control_sd = c(2.0, 2.3), control_n = c(20, 18),
  fire_sd = c(2.8, 3.1), fire_n = c(19, 20),
  grazing_sd = c(2.2, 2.5), grazing_n = c(21, 17),
  fire_grazing_sd = c(3.5, 3.8), fire_grazing_n = c(18, 19)
)

result <- lnVR_main(
  data = data,
  Ctrl_sd = "control_sd", Ctrl_n = "control_n",
  A_sd = "fire_sd", A_n = "fire_n",
  B_sd = "grazing_sd", B_n = "grazing_n",
  AB_sd = "fire_grazing_sd", AB_n = "fire_grazing_n"
)

}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
