% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_dist.R
\name{abouheif}
\alias{abouheif}
\title{Compute the Abouheif distance matrix}
\usage{
abouheif(tree)
}
\arguments{
\item{tree}{A data frame representing a transmission tree, with the first column containing the infector IDs and the second the infectee IDs.}
}
\value{
A square, symmetric matrix of Abouheif distances between nodes.
}
\description{
The Abouheif distance is the product of the number of direct descendants of each node in the path between two nodes.
It is a measure of the number of transmission events between two nodes.
}
\examples{
tree <- data.frame(from = c(1, 1, 2, 2, 3, 3), to = c(2, 3, 4, 5, 6, 7))
abouheif(tree)
}
