% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_descriptions.R
\docType{data}
\name{bays2009_full}
\alias{bays2009_full}
\title{Full data set from Bays et al. (2009)}
\format{
A data frame with 7271 rows and 10 variables:
\describe{
  \item{id}{participant identification}
  \item{set_size}{the set size of each trial}
  \item{duration}{the duration of the sample array (in milliseconds, ms),
  with levels 100ms, 500ms, 2000ms}
  \item{response}{the participant's recollection of the target orientation
  in radians (-pi to pi)}
  \item{target}{the feature value of the target in radians (-pi to pi)}
  \item{non_target_1}{the feature value of the first non-target in radians
  (-pi to pi)}
  \item{non_target_2}{the feature value of the second non-target in radians
  (-pi to pi)}
  \item{non_target_3}{the feature value of the third non-target in radians
  (-pi to pi)}
  \item{non_target_4}{the feature value of the fourth non-target in radians
  (-pi to pi)}
  \item{non_target_5}{the feature value of the fifth non-target in radians
  (-pi to pi)}
}
}
\source{
The data set is publicly available on the Open Science Framework, with thanks
to Paul Bays: https://osf.io/c2yx5/
}
\usage{
bays2009_full
}
\description{
A full data set including data from 12 participants in a continuous report
visual short-term memory experiment. The stimuli were coloured squares
in the range radians -pi to pi. The experiment had various set sizes and
an additional manipulation of duration of the sample array presentation.
}
\references{
Bays, P.M., Catalao, R.F.G., & Husain, M. (2009). The precision of visual
   working memory is set by allocation of a shared resource. Journal of
   Vision, 9(10), Article 7.
}
\keyword{datasets}
