% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_qcf.R
\encoding{UTF-8}
\name{dis_qcf}
\alias{dis_qcf}
\title{Constructs a pairwise distance matrix based on the quantile cross-covariance
function}
\usage{
dis_qcf(X, levels = c(0.1, 0.5, 0.9), max_lag = 1, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{levels}{The set of probability levels.}

\item{max_lag}{The maximum lag considered to compute the cross-covariances.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{QCF}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{QCF}}.
}
\description{
\code{dis_qcf} returns a pairwise distance matrix based on a generalization of the
dissimilarity introduced by \insertCite{lafuente2016clustering;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined as
\deqn{d_{QCF}(\boldsymbol X_T, \boldsymbol Y_T)=\Bigg(\sum_{l=1}^{L}\sum_{i=1}^{r}\sum_{i'=1}^{r}\sum_{j_1=1}^{d}
\sum_{j_2=1}^{d}\bigg(\widehat \gamma_{j_1,j_2}^{\boldsymbol X_T}(l,\tau_i,\tau_{i^\prime})-\widehat \gamma_{j_1,j_2}^{\boldsymbol Y_T}
(l,\tau_i,\tau_{i^\prime})\bigg)^2+}
\deqn{\sum_{i=1}^{r}\sum_{i'=1}^{r}\sum_{{j_1,j_2=1: j_1 > j_2}}^{d}
\bigg(\widehat \gamma_{j_1,j_2}^{\boldsymbol X_T}(0,\tau_i,\tau_{i^\prime})-
\widehat \gamma_{j_1,j_2}^{\boldsymbol Y_T}(0,\tau_i,\tau_{i^\prime})\bigg)^2\Bigg]^{1/2},}
where \eqn{\widehat \gamma_{j_1,j_2}^{\boldsymbol X_T}(l,\tau_i,\tau_{i^\prime})} and
\eqn{\widehat \gamma_{j_1,j_2}^{\boldsymbol Y_T}(l,\tau_i,\tau_{i^\prime})} are estimates of the quantile cross-covariances
with respect to the variables \eqn{j_1} and \eqn{j_2} and probability levels \eqn{\tau_i} and \eqn{\tau_{i^\prime}} for
series \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, respectively.
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_qcf(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_qcf
feature_dataset <- dis_qcf(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{lafuente2016clustering}{mlmts}

}
}
\seealso{
\code{\link{dis_qcd}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
