% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deck_funcs.R
\name{shuffle_deck}
\alias{shuffle_deck}
\title{Shuffle a Deck of Cards}
\usage{
shuffle_deck(
  deck_of_cards = function(x) {
     standard_deck()
 },
  seed = NULL,
  paired = FALSE
)
}
\arguments{
\item{deck_of_cards}{An anonymous function that returns a deck of cards as
either a data frame or a list of two numeric vectors for interleaved decks.
Default is \code{function(x){standard_deck()}}.}

\item{seed}{An optional seed for reproducibility. Default is NULL.}

\item{paired}{Logical flag to indicate if the interleaved deck should be pair
shuffled. Default is FALSE.}
}
\value{
A data frame representing the shuffled deck of cards. The data frame
inherits various classes based on its type. All shuffled decks will have the
classes "ShuffledDeck" and "data.frame". Additional class inheritance depends
on the \code{deck_of_cards} parameter:
\itemize{
\item "StandardDeck" if \code{deck_of_cards} returns a standard deck (default)
\item "AnonymousDeck" if \code{deck_of_cards} returns a single vector
\item "InterleavedDeck" if \code{deck_of_cards} returns a list of two vectors.
If the \code{paired} parameter is set to TRUE, an interleaved deck will also
inherit the class "PairedDeck".
}
}
\description{
This function shuffles a deck of cards and returns the shuffled deck.
The function can handle standard decks, anonymous decks, and interleaved decks.
For interleaved decks, an option to pair shuffle is also available.
}
\examples{
# Standard deck
std_deck <- shuffle_deck()
head(std_deck)

# Anonymous deck
anon_deck <- shuffle_deck(deck_of_cards = function(x){runif(52, 1, 10)})
head(anon_deck)

# Interleaved deck
interleaved_deck <- shuffle_deck(
                        deck_of_cards = function(x){list(runif(26, 1, 5),
                                                         runif(26, 6, 10))})
head(interleaved_deck)

# Paired interleaved deck
paired_deck <- shuffle_deck(
                  deck_of_cards = function(x){list(runif(26, 1, 5),
                                                   runif(26, 6, 10))},
                  paired = TRUE)
head(paired_deck)

}
