% Generated by roxygen2 (4.0.1): do not edit by hand
\name{phi.mult}
\alias{phi.mult}
\title{Initial values for the variance components for Model 1}
\usage{
phi.mult(beta.0, y, Xk, M)
}
\arguments{
\item{beta.0}{initial values for the fixed effects obtained in \code{\link[mme]{initial.values}}.}

\item{y}{matrix with the response variable obtained from \code{\link[mme]{data.mme}}. The rows are the domains and the columns are the categories of the response variable.}

\item{Xk}{list of matrices with the auxiliary variables per category obtained from \code{\link[mme]{data.mme}}. The dimension of the list is the number of domains.}

\item{M}{vector with the sample size of the areas.}
}
\value{
phi.0 vector of inicial values for the variance components
}
\description{
This function is used in \code{\link[mme]{initial.values}} to calculate the initial values for the variance
components in the multinomial mixed model with one independent random effect in each category
of the response variable (Model 1).
}
\examples{
k=3 #number of categories of the response variable
pp=c(1,1) #vector with the number of auxiliary variables in each category
data(simdata) #data
mod=1 #type of model
datar=data.mme(simdata,k,pp,mod)
###beta values
beta.new=list()
beta.new[[1]]=matrix(c( 1.3,-1),2,1)
beta.new[[2]]=matrix(c( -1.6,1),2,1)

##Initial variance components
phi=phi.mult(beta.new,datar$y,datar$Xk,datar$n)
}
\references{
Lopez-Vizcaino, ME, Lombardia, MJ and Morales, D (2013).
Multinomial-based small area estimation of labour force indicators.
Statistical Modelling, 13, 153-178.
}
\seealso{
\code{\link[mme]{data.mme}}, \code{\link[mme]{initial.values}},
\code{\link[mme]{wmatrix}}, \code{\link[mme]{prmu}},
\code{\link[mme]{Fbetaf}}, \code{\link[mme]{phi.direct}},
\code{\link[mme]{sPhikf}}, \code{\link[mme]{ci}},
\code{\link[mme]{modelfit1}}, \code{\link[mme]{msef}},
\code{\link[mme]{mseb}}.
}
\keyword{models}

