% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_bootstrap.R
\name{summarise_bootstrap}
\alias{summarise_bootstrap}
\title{Apply a differentiation statistic to a bootstrap sample}
\usage{
summarise_bootstrap(bs, statistic)
}
\arguments{
\item{bs}{list of genind objects}

\item{statistic}{differentiation statistic to apply (the function itself, 
as with apply family functions)}
}
\value{
per.locus:  \code{matirx} of statistics calculated for each locus (column) and each 
bootstrap replicate (row).

global.het: \code{vector} of global estimates calculated from overall 
heterozygosity

global.het: \code{vector} of global estimates calculated from harmonic
mean of statistic (only applied to D_Jost)

summary.loci: \code{data.frame} summarising the distribution of the
chosen statistic across replicates. Details of the different confidence
intervals are given in details

summary.global_het: A vector containing the same measures as
\code{summary.loci} but for a global value of the statistic calculated from
all loci

summary.global_harm: As with \code{summary.global_het} but calculated
from the harmonic mean of the statistic across loci (only applies to D_Jost)
}
\description{
This function applies a differentiation statistic (eg, D_Jost, Gst_Hedrick or 
Gst_Nei) to a list of genind objects, possibly produced with
chao_bootsrap or jacknife_populations.
}
\details{
Two different approaches are used for calculating confidence intervals in the
results. The estimates given by \code{lower.percentile} and \code{upper.percentile}
are simply the \code{2.5}th and \code{97.5}th precentile of the statistic
across bootstrap samples. Note, the presence or rare alleles in some
populations can bias bootstrapping procedures such that these intervals
are not centered on the observed value. The mean of statistic across
samples is returned as \code{mean.bs} and can be used to correct biased
bootsrap samples. Alternatively, \code{lower.normal} and \code{upper.normal}
form a confidence interval centered on the observed value of the statistic
and using the standard deviation of the statistic across replicates to
generate limits (sometimes called the normal-method of obtaining a confidence
interval). The print function for objects returned by this function displays 
the normal-method confidence intervals.
}
\examples{
\dontrun{  
data(nancycats)
bs <- chao_bootstrap(nancycats)
summarise_bootstrap(bs, D_Jost)
}
}
\seealso{
Other resample: \code{\link{chao_bootstrap}},
  \code{\link{jacknife_populations}}
}
