% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{Rank}
\alias{Rank}
\title{Ranking a vector}
\usage{
Rank(x, decreasing = FALSE)
}
\arguments{
\item{x}{a numeric vector}

\item{decreasing}{logical. Should the sort order be increasing or decreasing? (defualt: FALSE)}
}
\value{
the rank of the vector elements
}
\description{
Ranking a vector
}
\details{
hint: What is the difference between Order and Rank\cr
Order: [the index of the greatest number, ..., the index of the smallest number]\cr
Rank: [the rank of the 1st number, ..., the rank of the last number]\cr
In Rank, the order of the numbers remains constant so can be used for ranksum.\cr
ex) \cr
    > a = c(10, 20, 50, 30, 40)\cr
    > order(a)\cr
    [1] 1 2 4 5 3]]\cr
    > Rank(a)\cr
    [1] 1 2 5 3 4
}
\examples{
a = c(10, 20, 50, 30, 40)
Rank(a)

}
