% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ednn_basis_functions.R
\name{ednn_IOprepare}
\alias{ednn_IOprepare}
\title{Preparing the input and output of the EDNN for a multiplex graph}
\usage{
ednn_IOprepare(
  edge.list,
  edge.weight,
  outcome = NULL,
  indv.index = NULL,
  edge.threshold = 0,
  walk.rep = 10,
  n.steps = 5,
  random.walk = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{edge.list}{edge list as a dataframe with two columns.}

\item{edge.weight}{edge weights as a dataframe. Each column corresponds to a graph. By default, the \code{colnames} are considered as outcomes unless indicated in \code{outcome} argument.}

\item{outcome}{clinical outcomes for each graph. If not mentioned, the \code{colnames(edge.weight)} are considered by default.}

\item{indv.index}{the index of individual networks.}

\item{edge.threshold}{numeric value to set edge weights below the threshold to zero (default: 0). the greater edge weights do not change.}

\item{walk.rep}{number of repeats for the random walk (default: 100).}

\item{n.steps}{number of the random walk steps (default: 5).}

\item{random.walk}{boolean value to enable the random walk algorithm (default: TRUE).}

\item{verbose}{if \emph{TRUE} a progress bar is shown.}
}
\value{
the input and output required to train the EDNN
}
\description{
Preparing the input and output of the EDNN for a multiplex graph
}
\examples{
myNet = network_gen(N_nodes = 50)
graphData = myNet[["data_graph"]]
edge.list = graphData[,1:2]
edge.weight = graphData[,3:4]
XY = ednn_IOprepare(edge.list, edge.weight)
X = XY[["X"]]
Y = XY[["Y"]]

}
