% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLayerNet_functions.R
\name{mnda_embedding}
\alias{mnda_embedding}
\title{Calculate the embedding space for a multiplex network}
\usage{
mnda_embedding(
  graph.data,
  outcome,
  indv.index = NULL,
  edge.threshold = 0,
  train.rep = 50,
  embedding.size = 2,
  epochs = 10,
  batch.size = 5,
  l2reg = 0,
  walk.rep = 100,
  n.steps = 5,
  random.walk = TRUE,
  demo = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{graph.data}{dataframe of the graph data containing edge list and edge weights.
column 1 and 2 consisting of the edge list (undirected).
column 3 and 4 consisting the edge weights corresponding to each graph, respectively.}

\item{outcome}{a vector of outcomes for each network.}

\item{indv.index}{the index of individual networks.}

\item{edge.threshold}{numeric value to set edge weights below the threshold to zero (default: 0). the greater edge weights do not change.}

\item{train.rep}{numeric value to set the number of EDNN training repeats (default: 50).}

\item{embedding.size}{the dimension of embedding space, equal to the number of the bottleneck hidden nodes (default: 5).}

\item{epochs}{maximum number of pocks. An early stopping callback with a patience of 5 has been set inside the function (default = 10).}

\item{batch.size}{batch size for learning (default = 5).}

\item{l2reg}{the coefficient of L2 regularization for the input layer (default = 0).}

\item{walk.rep}{number of repeats for the random walk (default: 100).}

\item{n.steps}{number of the random walk steps (default: 5).}

\item{random.walk}{boolean value to enable the random walk algorithm (default: TRUE).}

\item{demo}{a boolean vector to indicate this is a demo example or not}

\item{verbose}{if \emph{TRUE} a progress bar is shown.}
}
\value{
a list of embedding spaces for each node.
}
\description{
Calculate the embedding space for a multiplex network
}
\examples{
myNet = network_gen(N_nodes = 50, N_var_nodes = 5, N_var_nei = 40, noise_sd = .01)
graph_data = myNet[["data_graph"]]
embeddingSpaceList = mnda_embedding(graph.data=graph_data, outcome=c(1,2),
train.rep=2, random.walk=FALSE)

}
